<?php

namespace api\components;

use Yii;
use yii\web\UrlRuleInterface;
use yii\base\BaseObject;
use common\models\Bots;
use common\models\Proxylog;
use yii\db\Expression;
use yii\validators\IpValidator;

class BotUrlRule extends BaseObject implements UrlRuleInterface
{
    public function createUrl($manager, $route, $params)
    {
        return false; // this rule does not apply
    }

    public function parseRequest($manager, $request)
    {
        if($this->linkValidate($request->getPathInfo())) {
            $r = explode('/',$request->getPathInfo());

            // find bot
            $m = Bots::find()->where(['like','bot',$r[0]])->one();

            if(!isset($_COOKIE['group'])){
                $group = 'Unrecognized';
            }else{
                $group = $_COOKIE['group'];
            }

            // fix any actions
            $p = New Proxylog();
            $headers = Yii::$app->request->headers;
            $via = 'No proxy';
            $v = (isset($headers['via'])) ? $headers['via'] : 'No proxy';
            $vv = explode(' ', $v);
            if(isset($vv[1])){
                $vvv = explode(':',$vv[1]);
                if(isset($vvv[0])){
                    $via = $vvv[0];
                }
            }
            // $p->ip = Yii::$app->request->userIP;
            $p->ip = $via;
            $p->created_at = new Expression('NOW()');
            $p->bot_id = ($m) ? $m->id : null;
            $p->group = $group;
            $p->save(false);

            if($m){
                switch ($r[1]) {
                    case '2':
                        return ['site/request', []];
                        break;
                    case '3':
                        return ['site/response', []];
                        break;
                    case '4':
                        return ['site/message', []];
                        break;
                    default:
                        throw new \yii\web\NotFoundHttpException();
                        break;
                }
            }else{
                return ['site/create', []];
            }

        }

        return ['site/badlink', []];
        
    }

    public function linkValidate($link){

        $r = explode('/',$link);
        $comms = [2,3,4]; // commands: 2 - request 3 - response 4 - message

        if(count($r) < 2){
            //throw new \yii\web\NotFoundHttpException('error 40400');
            die();
        }else{
            if(array_search(intval($r[1]), $comms)===false){
                //throw new \yii\web\NotFoundHttpException('error 40401');
                die();
            }
        }

        return true;
    }

    
}